package org.mule.weave.v2.runtime.core.functions.runtime

import org.mule.weave.v2.core.functions.SecureEmptyFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.service.WeaveRuntimePrivilege
import org.mule.weave.v2.model.structure.ObjectSeq
import org.mule.weave.v2.model.values.ObjectValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value

object SystemPropFunctionValue extends SecureEmptyFunctionValue {

  override val requiredPrivilege: WeaveRuntimePrivilege = WeaveRuntimePrivilege.SYSTEM_PROPS

  override def onSecureExecution()(implicit ctx: EvaluationContext): Value[_] = {
    ObjectValue(ObjectSeq(ctx.serviceManager.propertiesService.props().mapValues(StringValue(_))))
  }
}
