package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode

object OverloadedFunctionNodeSerializer extends AstNodeSerializer[OverloadedFunctionNode] {

  override protected def doSerialize(node: OverloadedFunctionNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val directives = FunctionDirectiveNodeSerializer.serializeSeq(node.functionDirectives)
    val children: Seq[SerializableAstNode] = Seq(_annotations, directives)
    NodeSerializableAstNode(SerializableAstNodeKind.OVERLOADED_FUNCTION_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): OverloadedFunctionNode = {
    val directives = FunctionDirectiveNodeSerializer.deserializeSeq(children.head, context)
    OverloadedFunctionNode(directives)
  }
}
