package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ TypeParameterNode, WeaveTypeNode }

object TypeParameterNodeSerializer extends AstNodeSerializer[TypeParameterNode] {

  override protected def doSerialize(node: TypeParameterNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val base = AstToSerializableMapper.serializeMaybe(node.base)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, base)
    NodeSerializableAstNode(SerializableAstNodeKind.TYPE_PARAMETER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): TypeParameterNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, context)
    val base = AstToSerializableMapper.deserializeMaybe(children(1), context).asInstanceOf[Option[WeaveTypeNode]]
    TypeParameterNode(name, base)
  }
}
