package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.structure.UriNode

object UriNodeSerializer extends AstNodeSerializer[UriNode] {

  override protected def doSerialize(node: UriNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = serializeString(node.literalValue)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.URI_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UriNode = {
    val value = deserializeString(children.head)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), context)
    UriNode(value, annotations)
  }
}
