package org.mule.weave.v2.interpreted.node.structure.header.directives

class ExecutionDirectiveNode(val options: Option[Seq[DirectiveOption]]) extends Directive with Configurable {

  override def productElement(n: Int): Any = {
    options match {
      case Some(opts) => opts.apply(n)
      case _          => null
    }
  }

  override def productArity: Int = options match {
    case Some(opts) => opts.size
    case _          => 0
  }

}