package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.WithValueAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.functions.OverloadedFunctionNode
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class StaticFunctionCallMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case vrn: VariableReferenceNode =>
        if (!vrn.isAnnotatedWith(classOf[StaticFunctionCallAnnotation])) {
          scope.resolveVariable(vrn.variable) match {
            case Some(value) =>
              val referencedNode = value.referencedNode
              value.scope.astNavigator().parentOf(referencedNode) match {
                case Some(fdn: FunctionDirectiveNode) =>
                  fdn.literal match {
                    case fn: FunctionNode =>
                      val arity = fn.params.paramList.size
                      vrn.annotate(StaticFunctionCallAnnotation(Seq(arity)))
                    case ofn: OverloadedFunctionNode =>
                      val arities: Seq[Int] = ofn.functions.map(f => {
                        f.params.paramList.size
                      })
                      vrn.annotate(StaticFunctionCallAnnotation(arities))
                  }
                case _ =>
                // Nothing to do
              }
            case _ =>
            // Nothing to do
          }
        }

      case _ =>
      // Nothing to do
    }
  }
}

case class StaticFunctionCallAnnotation(arities: Seq[Int]) extends WithValueAstNodeAnnotation[Seq[Int]] {
  override def toString: String = "StaticFunctionCallAnnotation([" + arities.mkString(",") + "])"

  override def name(): String = {
    "StaticFunctionCall"
  }

  def isFunctionOfArity(arity: Int): Boolean = {
    arities.forall(_ == arity)
  }

  def isOverloaded: Boolean = {
    arities.size > 1
  }

  override def value(): Seq[Int] = {
    arities
  }
}