package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ KeyTypeNode, WeaveTypeNode }

object KeyTypeNodeSerializer extends AstNodeSerializer[KeyTypeNode] {

  override protected def doSerialize(node: KeyTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameTypeNodeSerializer.serialize(node.name)
    val attrs = AstToSerializableMapper.serializeSeq(node.attrs)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, attrs, annotations, maybeSchema, maybeTypeSchema)
    NodeSerializableAstNode(SerializableAstNodeKind.KEY_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): KeyTypeNode = {
    val name = NameTypeNodeSerializer.deserialize(children.head, context)
    val attrs = AstToSerializableMapper.deserializeSeq(children(1), context).asInstanceOf[Seq[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(3), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(4), context)
    KeyTypeNode(name, attrs, annotations, maybeSchema, maybeTypeSchema)
  }
}
