package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.selectors.NullSafeNode

object NullSafeNodeSerializer extends AstNodeSerializer[NullSafeNode] {

  override protected def doSerialize(node: NullSafeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = AstToSerializableMapper.serialize(node.selector)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.NULL_SAFE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NullSafeNode = {
    val selector = AstToSerializableMapper.deserialize(children.head, context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), context)
    NullSafeNode(selector, annotations)
  }
}
