package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation.mapper.nonAst.AstNodeAnnotationSerializer
import org.mule.weave.v2.compilation.mapper.{ DWSerializer, SerializableLocationMapper, SerializerContext }
import org.mule.weave.v2.compilation.{ ArraySerializableAstNode, SerializableAstNode, SerializableAstNodeLocation }
import org.mule.weave.v2.parser.annotation.EphemeralAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode

trait AstNodeSerializer[T <: AstNode] extends DWSerializer[T] {

  override final def serialize(node: T): SerializableAstNode = {
    val location = SerializableLocationMapper.serialize(node.location())
    val runtimeAnnotations = node.annotations().filterNot(_.isInstanceOf[EphemeralAstNodeAnnotation])
    val _annotations = ArraySerializableAstNode(runtimeAnnotations.map(AstNodeAnnotationSerializer.serialize))

    doSerialize(node, location, _annotations)
  }

  override final def deserialize(node: SerializableAstNode, context: SerializerContext): T = {
    val location = SerializableLocationMapper.deserialize(node.location(), context)
    val annotations = AstNodeAnnotationSerializer.deserializeSeq(node.children().head, context)
    val children = node.children().slice(1, node.children().length)

    val astNode = doDeserialize(children, context)

    astNode._location = Some(location)
    annotations.foreach(astNode.annotate)
    astNode
  }

  protected def doSerialize(node: T, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode

  protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): T
}
