package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.updates.AttributeNameUpdateSelectorNode

object AttributeNameUpdateSelectorNodeSerializer extends AstNodeSerializer[AttributeNameUpdateSelectorNode] {

  override protected def doSerialize(node: AttributeNameUpdateSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selector = AstToSerializableMapper.serialize(node.selector)
    val child = AstToSerializableMapper.serializeMaybe(node.child)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selector, child)
    NodeSerializableAstNode(SerializableAstNodeKind.ATTRIBUTE_NAME_UPDATE_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AttributeNameUpdateSelectorNode = {
    val selector = AstToSerializableMapper.deserialize(children.head, context)
    val child = AstToSerializableMapper.deserializeMaybe(children(1), context)
    AttributeNameUpdateSelectorNode(selector, child)
  }
}
