package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.DynamicNameNode

object DynamicNameNodeSerializer extends AstNodeSerializer[DynamicNameNode] {

  override protected def doSerialize(node: DynamicNameNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val keyName = AstToSerializableMapper.serialize(node.keyName)
    val children: Seq[SerializableAstNode] = Seq(_annotations, keyName)
    NodeSerializableAstNode(SerializableAstNodeKind.DYNAMIC_NAME_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DynamicNameNode = {
    val keyName = AstToSerializableMapper.deserialize(children.head, context)
    DynamicNameNode(keyName)
  }
}
