package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.HeadTailArrayNode

object HeadTailArrayNodeSerializer extends AstNodeSerializer[HeadTailArrayNode] {

  override protected def doSerialize(node: HeadTailArrayNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val head = AstToSerializableMapper.serialize(node.head)
    val tail = AstToSerializableMapper.serialize(node.tail)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, head, tail, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.HEAD_TAIL_ARRAY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): HeadTailArrayNode = {
    val head = AstToSerializableMapper.deserialize(children.head, context)
    val tail = AstToSerializableMapper.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    HeadTailArrayNode(head, tail, annotations)
  }
}
