package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.schema.SchemaPropertyNode

object SchemaPropertyNodeSerializer extends AstNodeSerializer[SchemaPropertyNode] {

  override protected def doSerialize(node: SchemaPropertyNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = AstToSerializableMapper.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val condition = AstToSerializableMapper.serializeMaybe(node.condition)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, value, condition)
    NodeSerializableAstNode(SerializableAstNodeKind.SCHEMA_PROPERTY_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): SchemaPropertyNode = {
    val name = AstToSerializableMapper.deserialize(children.head, context)
    val value = AstToSerializableMapper.deserialize(children(1), context)
    val condition = AstToSerializableMapper.deserializeMaybe(children(2), context)
    SchemaPropertyNode(name, value, condition)
  }
}
