package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.marker.ExternalBindingAnnotation
import org.mule.weave.v2.interpreted.node.structure.header.ExternalBinding
import org.mule.weave.v2.interpreted.node.structure.header.ExternalBindings
import org.mule.weave.v2.interpreted.node.structure.header.HeaderNode
import org.mule.weave.v2.interpreted.node.structure.header.VariableTable
import org.mule.weave.v2.parser.annotation.MaterializeVariableAnnotation
import org.mule.weave.v2.parser.annotation.StreamingCapableVariableAnnotation
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.header.directives.InputDirective

trait EngineHeaderTransformations extends EngineVariableTransformations {

  val _variablesTable: VariableTable

  val _modulesNameTable: VariableTable

  val _externalBindings: ExternalBindings

  def transformHeaderNode(directives: Seq[DirectiveNode], transformationStack: TransformationStack): HeaderNode = {
    //We filter import directives as they are not used in runtime
    val runtimeDirectives = directives.filterNot(directive => directive.isInstanceOf[ImportDirective] || directive.isInstanceOf[InputDirective] || directive.isInstanceOf[AnnotationDirectiveNode])
    // Adding external bindings
    directives.filter(d => d.isInstanceOf[InputDirective]).foreach(d => {
      val id = d.asInstanceOf[InputDirective]
      addInputDirectiveToExternalBindings(id, transformationStack)
    })
    new HeaderNode(transformSeq(runtimeDirectives, transformationStack), _variablesTable, _modulesNameTable, _externalBindings)
  }

  private def addInputDirectiveToExternalBindings(id: InputDirective, transformationStack: TransformationStack): Unit = {
    val maybeExternalBindingAnnotation = id.annotation(classOf[ExternalBindingAnnotation])
    if (maybeExternalBindingAnnotation.isDefined) {
      val externalBindingAnnotation = maybeExternalBindingAnnotation.get
      val nameSlot = createNameSlot(externalBindingAnnotation.localVariableName)
      val canStream = id.variable.annotation(classOf[StreamingCapableVariableAnnotation]).exists(_.canStream)
      val needsMaterialize = id.variable.annotation(classOf[MaterializeVariableAnnotation]).exists(_.needMaterialize)
      val externalBinding = ExternalBinding(nameSlot, id.mime.orElse(id.dataFormat)
        .map(f => transformFormat(f)), transformOptionSeq(id.options, transformationStack), canStream, needsMaterialize)
      _externalBindings.addVariable(externalBinding)
    }
  }
}
