package org.mule.weave.v2.runtime.core.functions.types

import org.mule.weave.v2.core.functions.UnaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.IntersectionType
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.ArrayValue
import org.mule.weave.v2.model.values.TypeValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.runtime.core.functions.types.exceptions.InvalidTypeException

object IntersectionTypeItemsFunction extends UnaryFunctionValue {
  override val R = TypeType

  override def doExecute(v: R.V)(implicit executionContext: EvaluationContext): Value[_] = {
    v.evaluate.baseType match {
      case it: IntersectionType => ArrayValue(it.of.map((t) => TypeValue(t)))
      case t                    => throw new InvalidTypeException(location, "Union", t.name)
    }
  }
}
