package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode

object FunctionCallNodeSerializer extends AstNodeSerializer[FunctionCallNode] {

  override protected def doSerialize(node: FunctionCallNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val function = AstToSerializableMapper.serialize(node.function)
    val args = FunctionCallParametersNodeSerializer.serialize(node.args)
    val typeParameters = TypeParametersApplicationListNodeSerializer.serializeMaybe(node.typeParameters)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, function, args, typeParameters, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_CALL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionCallNode = {
    val function = AstToSerializableMapper.deserialize(children.head, context)
    val args = FunctionCallParametersNodeSerializer.deserialize(children(1), context)
    val typeParameters = TypeParametersApplicationListNodeSerializer.deserializeMaybe(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    FunctionCallNode(function, args, typeParameters, annotations)
  }
}
