package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.ImportedElements

object ImportedElementsSerializer extends AstNodeSerializer[ImportedElements] {

  override protected def doSerialize(node: ImportedElements, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elements = ImportedElementSerializer.serializeSeq(node.elements)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elements)
    NodeSerializableAstNode(SerializableAstNodeKind.IMPORTED_ELEMENTS_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ImportedElements = {
    val elements = ImportedElementSerializer.deserializeSeq(children.head, context)
    ImportedElements(elements)
  }
}
