package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.node.ModuleNode
import org.mule.weave.v2.parser
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.header.directives.InputDirective

trait EngineModuleTransformations extends EngineImportTransformations {

  def transformModuleNode(module: parser.ast.module.ModuleNode, transformationStack: TransformationStack): ModuleNode = {
    val runtimeDirectives = module.directives.filterNot((directive) => directive.isInstanceOf[ImportDirective] || directive.isInstanceOf[InputDirective] || directive.isInstanceOf[AnnotationDirectiveNode])
    new ModuleNode(transformImportDirectives(module), transformSeq(runtimeDirectives, transformationStack), _variablesTable, _modulesNameTable)
  }

}
