package org.mule.weave.v2.runtime.core.operator.conversion

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.AnyType
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.model.types.TypeType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location._

class AsFunctionValue(override val location: WeaveLocation, requiresMaterialize: Boolean) extends BinaryFunctionValue {
  override val L = AnyType

  override val R = TypeType

  override def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val asType: Type = rightValue.evaluate
    val coerce = asType.coerce(if (requiresMaterialize) leftValue.materialize else leftValue, this)
    coerce
  }

}

