package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.{ ObjectTypeNode, WeaveTypeNode }

object ObjectTypeNodeSerializer extends AstNodeSerializer[ObjectTypeNode] {

  override protected def doSerialize(node: ObjectTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val properties = AstToSerializableMapper.serializeSeq(node.properties)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val closed = serializeBoolean(node.close)
    val ordered = serializeBoolean(node.ordered)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, properties, maybeSchema, maybeTypeSchema, closed, ordered, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.OBJECT_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ObjectTypeNode = {
    val properties = AstToSerializableMapper.deserializeSeq(children.head, context).asInstanceOf[Seq[WeaveTypeNode]]
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(1), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), context)
    val closed = deserializeBoolean(children(3))
    val ordered = deserializeBoolean(children(4))
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(5), context)
    ObjectTypeNode(properties, maybeSchema, maybeTypeSchema, closed, ordered, annotations)
  }
}
