/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.compilation.loader;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.Serializable;
import org.mule.weave.v2.compilation.SerializableAstNode;
import org.mule.weave.v2.compilation.mapper.ParserInputBasedSerializerContext;
import org.mule.weave.v2.compilation.mapper.ast.ModuleNodeSerializer$;
import org.mule.weave.v2.compilation.message.WeaveBinaryDeserializationError;
import org.mule.weave.v2.compilation.serializer.SerializableAstNodeSerializer$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCollector$;
import org.mule.weave.v2.parser.SafeStringBasedParserInput;
import org.mule.weave.v2.parser.SafeStringBasedParserInput$;
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation;
import org.mule.weave.v2.parser.annotation.PreCompiledTypeAnnotation;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ModuleLoader;
import org.mule.weave.v2.parser.phase.ModuleLoader$;
import org.mule.weave.v2.parser.phase.ParsingContentInput;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.BinaryWeaveResource;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.sdk.WeaveResourceResolverAware;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4AAC\u0006\u00011!)Q\u0006\u0001C\u0001]!I\u0011\u0007\u0001a\u0001\u0002\u0004%IA\r\u0005\nm\u0001\u0001\r\u00111A\u0005\n]B\u0011\"\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u001a\t\u000by\u0002A\u0011I \t\u000b9\u0003A\u0011I(\t\u000bE\u0002A\u0011\t7\t\u000b9\u0004A\u0011B8\t\u000b]\u0004A\u0011\t=\u0003?]+\u0017M^3CS:\f'/\u001f*fg>,(oY3N_\u0012,H.\u001a'pC\u0012,'O\u0003\u0002\r\u001b\u00051An\\1eKJT!AD\b\u0002\u0017\r|W\u000e]5mCRLwN\u001c\u0006\u0003!E\t!A\u001e\u001a\u000b\u0005I\u0019\u0012!B<fCZ,'B\u0001\u000b\u0016\u0003\u0011iW\u000f\\3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\r OA\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u000bAD\u0017m]3\u000b\u0005\u0011z\u0011A\u00029beN,'/\u0003\u0002'C\taQj\u001c3vY\u0016du.\u00193feB\u0011\u0001fK\u0007\u0002S)\u0011!fD\u0001\u0004g\u0012\\\u0017B\u0001\u0017*\u0005i9V-\u0019<f%\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ\fu/\u0019:f\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u00021\u00015\t1\"\u0001\u0005sKN|GN^3s+\u0005\u0019\u0004C\u0001\u00155\u0013\t)\u0014FA\u000bXK\u00064XMU3t_V\u00148-\u001a*fg>dg/\u001a:\u0002\u0019I,7o\u001c7wKJ|F%Z9\u0015\u0005aZ\u0004C\u0001\u000e:\u0013\tQ4D\u0001\u0003V]&$\bb\u0002\u001f\u0004\u0003\u0003\u0005\raM\u0001\u0004q\u0012\n\u0014!\u0003:fg>dg/\u001a:!\u0003\u0011q\u0017-\\3\u0015\u0003\u0001\u00032AG!D\u0013\t\u00115D\u0001\u0004PaRLwN\u001c\t\u0003\t.s!!R%\u0011\u0005\u0019[R\"A$\u000b\u0005!;\u0012A\u0002\u001fs_>$h(\u0003\u0002K7\u00051\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQ5$\u0001\u0006m_\u0006$Wj\u001c3vY\u0016$2\u0001U0h!\rQ\u0012)\u0015\t\u0004AI#\u0016BA*\"\u0005-\u0001\u0006.Y:f%\u0016\u001cX\u000f\u001c;\u0011\u0007\u0001*v+\u0003\u0002WC\ti\u0001+\u0019:tS:<'+Z:vYR\u0004\"\u0001W/\u000e\u0003eS!AW.\u0002\r5|G-\u001e7f\u0015\ta6%A\u0002bgRL!AX-\u0003\u00155{G-\u001e7f\u001d>$W\rC\u0003a\r\u0001\u0007\u0011-\u0001\boC6,\u0017\nZ3oi&4\u0017.\u001a:\u0011\u0005\t,W\"A2\u000b\u0005\u0011\\\u0016!\u0003<be&\f'\r\\3t\u0013\t17M\u0001\bOC6,\u0017\nZ3oi&4\u0017.\u001a:\t\u000b!4\u0001\u0019A5\u0002\u001bA\f'/\u001a8u\u0007>tG/\u001a=u!\t\u0001#.\u0003\u0002lC\tq\u0001+\u0019:tS:<7i\u001c8uKb$HC\u0001\u001dn\u0011\u0015\tt\u00011\u00014\u0003E\u0001\u0018M]:f\u0005&t\u0017M]=N_\u0012,H.\u001a\u000b\u0004#B\u0014\b\"B9\t\u0001\u0004\t\u0017AC5eK:$\u0018NZ5fe\")1\u000f\u0003a\u0001i\u0006A!/Z:pkJ\u001cW\r\u0005\u0002)k&\u0011a/\u000b\u0002\u0014\u0005&t\u0017M]=XK\u00064XMU3t_V\u00148-Z\u0001\u0011G\u0006t'+Z:pYZ,Wj\u001c3vY\u0016$\"!\u001f?\u0011\u0005iQ\u0018BA>\u001c\u0005\u001d\u0011un\u001c7fC:DQ\u0001Y\u0005A\u0002\u0005\u0004")
public class WeaveBinaryResourceModuleLoader
implements ModuleLoader,
WeaveResourceResolverAware {
    private WeaveResourceResolver resolver;

    public Option<WeaveResource> moduleContent(NameIdentifier nameIdentifier, ParsingContext parsingContext) {
        return ModuleLoader.moduleContent$((ModuleLoader)this, (NameIdentifier)nameIdentifier, (ParsingContext)parsingContext);
    }

    private WeaveResourceResolver resolver() {
        return this.resolver;
    }

    private void resolver_$eq(WeaveResourceResolver x$1) {
        this.resolver = x$1;
    }

    public Option<String> name() {
        return new Some((Object)ModuleLoader$.MODULE$.BINARY_LOADER_NAME());
    }

    public Option<PhaseResult<ParsingResult<ModuleNode>>> loadModule(NameIdentifier nameIdentifier, ParsingContext parentContext) {
        parentContext.notificationManager().startResolvingResource(nameIdentifier, this.resolver());
        Option resolve = this.resolver().resolveBinary(nameIdentifier);
        parentContext.notificationManager().endResolvingResource(nameIdentifier, this.resolver(), resolve);
        return resolve.map((Function1 & Serializable & scala.Serializable)resource -> this.parseBinaryModule(nameIdentifier, (BinaryWeaveResource)resource));
    }

    public void resolver(WeaveResourceResolver resolver) {
        this.resolver_$eq(resolver);
    }

    private PhaseResult<ParsingResult<ModuleNode>> parseBinaryModule(NameIdentifier identifier, BinaryWeaveResource resource) {
        PhaseResult phaseResult;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.binaryContent());
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        SafeStringBasedParserInput parserInput = SafeStringBasedParserInput$.MODULE$.apply(resource.content());
        ParsingContentInput input = new ParsingContentInput((WeaveResource)resource, identifier, parserInput);
        try {
            SerializableAstNode deserializedNode = SerializableAstNodeSerializer$.MODULE$.deserialize(dataInputStream);
            ModuleNode moduleNode = (ModuleNode)ModuleNodeSerializer$.MODULE$.deserialize(deserializedNode, new ParserInputBasedSerializerContext(parserInput, identifier));
            moduleNode.annotate((AstNodeAnnotation)new PreCompiledTypeAnnotation());
            phaseResult = new PhaseResult((Option)new Some((Object)new ParsingResult(input, (AstNode)moduleNode)), MessageCollector$.MODULE$.apply());
        }
        catch (Throwable e) {
            phaseResult = new PhaseResult((Option)None$.MODULE$, MessageCollector$.MODULE$.apply().error((Message)new WeaveBinaryDeserializationError(identifier, e.getMessage()), (WeaveLocation)UnknownLocation$.MODULE$));
        }
        return phaseResult;
    }

    public boolean canResolveModule(NameIdentifier nameIdentifier) {
        return this.resolver().canResolveResource(nameIdentifier);
    }

    public WeaveBinaryResourceModuleLoader() {
        ModuleLoader.$init$((ModuleLoader)this);
    }
}

