%dw 2.0

import * from dw::Runtime
import * from dw::Client

var response = {
  status: 200,
  // Adding attributes to force the creation of an AttributeDelegateValue instance
  body @(id: "456", category: "fiction"): lazyReadBinary("application/json", "{\"user\":\"Mari" as Binary)
}

---
{
  status: response.status,
  body: do {
    var bodyResult = try(() -> response.body)
    ---
    {
      success: bodyResult.success,
      error: {
        kind: bodyResult.error.kind,
        message: bodyResult.error.message
      },
      result: bodyResult.result
    }
  }
}
