%dw 2.0
import * from dw::Runtime
import * from dw::Client

var response = {
  status: 200,
  body: lazyReadBinary("application/json", "{\"user\":\"Mari" as Binary)
}

// Force ObjectValue materialization
var status = response.status
var result = try(() -> response)
---
{
 result: {
   success: result.success,
   result: result.result,
   error: {
     kind: result.error.kind,
     message: result.error.message
   }
 }
}
