package org.mule.weave.v2.compilation

import SerializableAstNodeKind.{ NONE_VALUE_NODE, STRING_VALUE_NODE }
import org.mule.weave.v2.compilation.SerializableAstNodeKind.BOOLEAN_VALUE_NODE
import org.mule.weave.v2.compilation.SerializableAstNodeKind.INT_VALUE_NODE

trait SerializableValueAstNode[T] extends SerializableAstNode {
  def value: T

  override def children(): Seq[SerializableAstNode] = Seq.empty

  override def location(): SerializableAstNodeLocation = UnknownLocation
}

case class StringSerializableValueAstNode(value: String) extends SerializableValueAstNode[String] {
  override def kind(): Short = STRING_VALUE_NODE
}

case class BooleanSerializableValueAstNode(value: Boolean) extends SerializableValueAstNode[Boolean] {
  override def kind(): Short = BOOLEAN_VALUE_NODE
}

case class IntSerializableValueAstNode(value: Int) extends SerializableValueAstNode[Int] {
  override def kind(): Short = INT_VALUE_NODE
}

case class NoneSerializableValueAstNode() extends SerializableValueAstNode[Null] {
  override def kind(): Short = NONE_VALUE_NODE

  override def value: Null = null
}