package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode
import org.mule.weave.v2.parser.ast.module.ModuleNode

object ModuleNodeSerializer extends AstNodeSerializer[ModuleNode] {

  override protected def doSerialize(node: ModuleNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val elements = AstToSerializableMapper.serializeSeq(node.elements)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, elements)
    NodeSerializableAstNode(SerializableAstNodeKind.MODULE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ModuleNode = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, context)
    val elements = AstToSerializableMapper.deserializeSeq(children(1), context).asInstanceOf[Seq[DirectiveNode]]
    ModuleNode(identifier, elements)
  }
}
