package org.mule.weave.v2.compilation.mapper.nonAst

import org.mule.weave.v2.compilation.{ NodeSerializableAstNode, SerializableAstNode, SerializableAstNodeKind, UnknownLocation }
import org.mule.weave.v2.compilation.mapper.{ DWSerializer, SerializerContext }
import org.mule.weave.v2.versioncheck.SVersion

object SVersionSerializer extends DWSerializer[SVersion] {
  override def serialize(version: SVersion): SerializableAstNode = {
    val children: Seq[SerializableAstNode] = Seq(
      serializeInt(version.mayor),
      serializeInt(version.minor),
      serializeInt(version.patch))
    NodeSerializableAstNode(SerializableAstNodeKind.SVERSION_NODE, UnknownLocation, children)
  }

  override def deserialize(node: SerializableAstNode, context: SerializerContext): SVersion = {
    SVersion(
      deserializeInt(node.children().head),
      deserializeInt(node.children()(1)),
      deserializeInt(node.children()(2)))
  }
}
