package org.mule.weave.v2.interpreted.transform

import org.mule.weave.v2.interpreted.marker.ReferenceAnnotation
import org.mule.weave.v2.interpreted.node.NameSlot
import org.mule.weave.v2.interpreted.node.structure.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.structure.NamespaceNode
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode
import org.mule.weave.v2.parser.exception.WeaveRuntimeException

trait EngineImportTransformations extends AstTransformation with EngineVariableTransformations with EngineHeaderTransformations {

  def transformImportDirectives(root: AstNode): Seq[ImportDirective] = {
    val allNodesWithReferences: Seq[AstNode] = AstNodeHelper.collectChildren(root, astNode => {
      classOf[VariableReferenceNode].isAssignableFrom(astNode.getClass) ||
        classOf[TypeReferenceNode].isAssignableFrom(astNode.getClass) ||
        classOf[NamespaceNode].isAssignableFrom(astNode.getClass) ||
        classOf[AnnotationNode].isAssignableFrom(astNode.getClass)
    })

    val importedModules: Seq[NameIdentifier] = allNodesWithReferences.flatMap(node => {
      node match {
        case vr: VariableReferenceNode => vr.variable.annotation(classOf[ReferenceAnnotation])
          .flatMap(_.referenceValue.moduleFQN)
        case tr: TypeReferenceNode => tr.variable.annotation(classOf[ReferenceAnnotation])
          .flatMap(_.referenceValue.moduleFQN)
        case ns: NamespaceNode => ns.prefix.annotation(classOf[ReferenceAnnotation])
          .flatMap(_.referenceValue.moduleFQN)
        case annotation: AnnotationNode => annotation.name.annotation(classOf[ReferenceAnnotation])
          .flatMap(_.referenceValue.moduleFQN)
      }
    })

    val distinctModules = importedModules.distinct
    distinctModules.map((moduleName) => {
      val nodeLoader = moduleLoader()
      val maybeNode = nodeLoader.compile(moduleName, parsingContext())
      val module = maybeNode.getOrElse(throw new WeaveRuntimeException(s"Unable to load module ${moduleName.name}", moduleName.location()))
      val moduleSlot: NameSlot = createModuleSlot(moduleName.name)
      _modules.insert(moduleSlot.slot, module.variableTable)
      new ImportDirective(moduleSlot, module)
    })
  }

}
