package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.HeadTailObjectNode

object HeadTailObjectNodeSerializer extends AstNodeSerializer[HeadTailObjectNode] {

  override protected def doSerialize(node: HeadTailObjectNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val headKey = AstToSerializableMapper.serialize(node.headKey)
    val headValue = AstToSerializableMapper.serialize(node.headValue)
    val tail = AstToSerializableMapper.serialize(node.tail)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, headKey, headValue, tail, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.HEAD_TAIL_OBJECT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): HeadTailObjectNode = {
    val headKey = AstToSerializableMapper.deserialize(children.head, context)
    val headValue = AstToSerializableMapper.deserialize(children(1), context)
    val tail = AstToSerializableMapper.deserialize(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    HeadTailObjectNode(headKey, headValue, tail, annotations)
  }
}
