%dw 2.0

import * from dw::core::Binaries
import * from dw::Runtime

// Binary
var base64Result = try(() ->  fromBase64(in0.invalidBase64))

// Materialized Binary
var materializedBase64Result = try(() ->  do {
  var decoded = fromBase64(in0.invalidBase64)
  ---
  {
    a: decoded,
    b: decoded[0]
  }
})
---
{
  base64Result: {
    success: base64Result.success,
    result: base64Result.result,
    error: {
      kind: base64Result.error.kind
    }
  },
  materializedBase64Result: {
    success: materializedBase64Result.success,
    result: materializedBase64Result.result,
    error: {
      kind: materializedBase64Result.error.kind
    }
  }
}