%dw 2.0

import * from dw::Runtime
import * from dw::Client

var response = {
  status: 200,
  // Adding attributes to force the creation of an AttributeDelegateValue instance
  body @(id: "456", category: "fiction"): lazyReadBinary("application/json", "{\"user\":\"Mari" as Binary)
}
// Force AttributeDelegateValue materialization
var body = response.body
var result = try(() -> do {
  body
})
---
{
  result: {
    success: result.success,
    result: result.result,
    error: {
      kind: result.error.kind,
      message: result.error.message
    }
  }
}
