package org.mule.weave.v2.compilation

import SerializableAstNodeKind.ARRAY_NODE

trait SerializableAstNode {
  def kind(): Short

  def location(): SerializableAstNodeLocation

  def children(): Seq[SerializableAstNode]
}

case class NodeSerializableAstNode(kind: Short, location: SerializableAstNodeLocation, children: Seq[SerializableAstNode]) extends SerializableAstNode

case class ArraySerializableAstNode(override val children: Seq[SerializableAstNode]) extends SerializableAstNode {
  override def kind(): Short = ARRAY_NODE

  override def location(): SerializableAstNodeLocation = UnknownLocation
}
