package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.types.DynamicReturnTypeNode

object DynamicReturnTypeNodeSerializer extends AstNodeSerializer[DynamicReturnTypeNode] {

  override protected def doSerialize(node: DynamicReturnTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    NodeSerializableAstNode(SerializableAstNodeKind.DYNAMIC_RETURN_TYPE_NODE, location, Seq(_annotations))
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DynamicReturnTypeNode = DynamicReturnTypeNode()
}
