package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.functions.UsingNode

object UsingNodeSerializer extends AstNodeSerializer[UsingNode] {

  override protected def doSerialize(node: UsingNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val assignments = UsingVariableAssignmentsSerializer.serialize(node.assignments)
    val expr = AstToSerializableMapper.serialize(node.expr)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, assignments, expr, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.USING_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UsingNode = {
    val assignments = UsingVariableAssignmentsSerializer.deserialize(children.head, context)
    val expr = AstToSerializableMapper.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    UsingNode(assignments, expr, annotations)
  }
}
