%dw 2.0
output application/json  skipNullOn="everywhere"
ns ns0 http://aggregation.wellsfargo.com/asdemodel/aggregation/2015/08/
---
{
  total_items:
    if (in0.ns0#TransactionsResponse.TransactionsPage.PageInfo.TotalItems == null)
      null
    else
      in0.ns0#TransactionsResponse.TransactionsPage.PageInfo.TotalItems as Number,
  total_pages:
    if (in0.ns0#TransactionsResponse.TransactionsPage.PageInfo.TotalPages == null)
      null
    else
      in0.ns0#TransactionsResponse.TransactionsPage.PageInfo.TotalPages as Number,
  page:
    if (in0.ns0#TransactionsResponse.TransactionsPage.PageInfo.PageNumber == null)
      null
    else
      in0.ns0#TransactionsResponse.TransactionsPage.PageInfo.PageNumber as Number,
  transactions: in0.ns0#TransactionsResponse.TransactionsPage.TransactionList.*Transaction map (transaction, indexOfTransaction) -> {
    transaction_id: transaction.TransactionId as String,
    description: transaction.Description,
    posted_timestamp:
      if (transaction.PostedTimestamp == null)
        null
      else
        transaction.PostedTimestamp as String,
    transaction_timestamp:
      if (transaction.TransactionTimestamp == null)
        null
      else
        transaction.TransactionTimestamp as String,
    debit_credit_memo: transaction.DebitCreditMemo,
    reference:
      if (transaction.Reference == null)
        null
      else
        transaction.Reference as String,
    transaction_type:
      if (transaction.TransactionType == null)
        null
      else
        transaction.TransactionType,
    amount: transaction.Amount as Number,
    status: transaction.Status,
    check_number:
      if (transaction.CheckNumber == null)
        null
      else
        transaction.CheckNumber as Number,
    category:
      if (transaction.Category == null)
        null
      else
        transaction.Category as String,
    sub_category:
      if (transaction.SubCategory == null)
        null
      else
        transaction.SubCategory as String,
    payee_name:
      if ((transaction.Memo == null or transaction.Memo == ""))
        null
      else if ((trim((transaction.Memo splitBy ",")[0])) == "")
        null
      else if ((trim(((transaction.Memo) splitBy ",")[0])) == "")
        null
      else
        (trim((transaction.Memo splitBy ",")[0])) as String,
    mcc:
      if ((transaction.Memo == null or transaction.Memo == ""))
        null
      else if (transaction.Memo contains ",")
        trim((transaction.Memo splitBy ",")[1])
      else
        null,
    payment_details:
      if (transaction.PaymentDetails == null)
        null
      else
        {
          principal_amount:
            if (transaction.PaymentDetails.PrincipalAmount == null)
              null
            else
              transaction.PaymentDetails.PrincipalAmount as Number,
          interest_amount:
            if (transaction.PaymentDetails.InterestAmount == null)
              null
            else
              transaction.PaymentDetails.InterestAmount as Number,
          escrow_amount:
            if (transaction.PaymentDetails.EscrowAmount == null)
              null
            else
              transaction.PaymentDetails.EscrowAmount as Number,
          insurance_amount:
            if (transaction.PaymentDetails.InsuranceAmount == null)
              null
            else
              transaction.PaymentDetails.InsuranceAmount as Number,
          pmi_amount:
            if (transaction.PaymentDetails.PMIAmount == null)
              null
            else
              transaction.PaymentDetails.PMIAmount as Number,
          fees_amount:
            if (transaction.PaymentDetails.FeesAmount == null)
              null
            else
              transaction.PaymentDetails.FeesAmount as Number
        },
    units:
      if (transaction.Units == null)
        null
      else
        transaction.Units as Number,
    unit_price:
      if (transaction.UnitPrice == null)
        null
      else
        transaction.UnitPrice as Number,
    symbol:
      if (transaction.Symbol == null)
        null
      else
        transaction.Symbol as String,
    security_id:
      if (transaction.SecurityId == null)
        null
      else
        transaction.SecurityId,
    security_type:
      if (transaction.SecurityType == null)
        null
      else
        transaction.SecurityType as String,
    commission:
      if (transaction.Commission == null)
        null
      else
        transaction.Commission as Number,
    confirmation_number:
      if (transaction.ConfirmationNumber == null)
        null
      else
        transaction.ConfirmationNumber as String
  }
}
