package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.annotation.AnnotationArgumentNode

object AnnotationArgumentNodeSerializer extends AstNodeSerializer[AnnotationArgumentNode] {

  override protected def doSerialize(node: AnnotationArgumentNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val children = Seq(_annotations, name, value)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_ARGUMENT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AnnotationArgumentNode = {
    val name = NameIdentifierSerializer.deserialize(children.head, context)
    val value = AstToSerializableMapper.deserialize(children(1), context)
    AnnotationArgumentNode(name, value)
  }
}
