package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode

object AnnotationDirectiveNodeSerializer extends AstNodeSerializer[AnnotationDirectiveNode] {

  override protected def doSerialize(node: AnnotationDirectiveNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val identifier = NameIdentifierSerializer.serialize(node.nameIdentifier)
    val params = AnnotationParametersNodeSerializer.serialize(node.params)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, identifier, params, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.ANNOTATION_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): AnnotationDirectiveNode = {
    val identifier = NameIdentifierSerializer.deserialize(children.head, context)
    val params = AnnotationParametersNodeSerializer.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    AnnotationDirectiveNode(identifier, params, annotations)
  }
}
