package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.ConditionalNode

object ConditionalNodeSerializer extends AstNodeSerializer[ConditionalNode] {

  override protected def doSerialize(node: ConditionalNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = AstToSerializableMapper.serialize(node.value)
    val cond = AstToSerializableMapper.serialize(node.cond)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, cond)
    NodeSerializableAstNode(SerializableAstNodeKind.CONDITIONAL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ConditionalNode = {
    val value = AstToSerializableMapper.deserialize(children.head, context)
    val cond = AstToSerializableMapper.deserialize(children(1), context)
    ConditionalNode(value, cond)
  }
}
