package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.header.directives.DirectiveOptionName

object DirectiveOptionNameSerializer extends AstNodeSerializer[DirectiveOptionName] {

  override protected def doSerialize(node: DirectiveOptionName, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val children: Seq[SerializableAstNode] = Seq(_annotations, serializeString(node.name))
    NodeSerializableAstNode(SerializableAstNodeKind.DIRECTIVE_OPTION_NAME_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): DirectiveOptionName = {
    DirectiveOptionName(deserializeString(children.head))
  }
}
