package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.types.LiteralTypeNode

object LiteralTypeNodeSerializer extends AstNodeSerializer[LiteralTypeNode] {

  override protected def doSerialize(node: LiteralTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val value = AstToSerializableMapper.serialize(node.value)
    val maybeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeSchema)
    val maybeTypeSchema = SchemaNodeSerializer.serializeMaybe(node.maybeTypeSchema)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, value, maybeSchema, maybeTypeSchema, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.LITERAL_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): LiteralTypeNode = {
    val value = AstToSerializableMapper.deserialize(children.head, context)
    val maybeSchema = SchemaNodeSerializer.deserializeMaybe(children(1), context)
    val maybeTypeSchema = SchemaNodeSerializer.deserializeMaybe(children(2), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    LiteralTypeNode(value, maybeSchema, maybeTypeSchema, annotations)
  }
}
