package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.structure.ObjectNode

object ObjectNodeSerializer extends AstNodeSerializer[ObjectNode] {

  override protected def doSerialize(node: ObjectNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val elements = AstToSerializableMapper.serializeSeq(node.elements)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, elements, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.OBJECT_LITERAL_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ObjectNode = {
    val elements = AstToSerializableMapper.deserializeSeq(children.head, context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(1), context)
    ObjectNode(elements, annotations)
  }
}
