package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.header.directives.OutputDirective
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

object OutputDirectiveSerializer extends AstNodeSerializer[OutputDirective] {

  override protected def doSerialize(node: OutputDirective, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val dataFormat = DataFormatIdSerializer.serializeMaybe(node.dataFormat)
    val mime = ContentTypeSerializer.serializeMaybe(node.mime)
    val options = DirectiveOptionSerializer.serializeMaybeSeq(node.options)
    val wtype = AstToSerializableMapper.serializeMaybe(node.wtype)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, dataFormat, mime, options, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.OUTPUT_DIRECTIVE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): OutputDirective = {
    val dataFormat = DataFormatIdSerializer.deserializeMaybe(children.head, context)
    val mime = ContentTypeSerializer.deserializeMaybe(children(1), context)
    val options = DirectiveOptionSerializer.deserializeMaybeSeq(children(2), context)
    val wtype = AstToSerializableMapper.deserializeMaybe(children(3), context).asInstanceOf[Option[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(4), context)
    OutputDirective(dataFormat, mime, options, wtype, annotations)
  }
}
