package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.updates.UpdateNode

object UpdateNodeSerializer extends AstNodeSerializer[UpdateNode] {

  override protected def doSerialize(node: UpdateNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val expression = AstToSerializableMapper.serialize(node.expression)
    val matchers = UpdateExpressionsNodeSerializer.serialize(node.matchers)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, expression, matchers, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.UPDATE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UpdateNode = {
    val expression = AstToSerializableMapper.deserialize(children.head, context)
    val matchers = UpdateExpressionsNodeSerializer.deserialize(children(1), context)
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(2), context)
    UpdateNode(expression, matchers, annotations)
  }
}
