package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignment

object UsingVariableAssignmentSerializer extends AstNodeSerializer[UsingVariableAssignment] {

  override protected def doSerialize(node: UsingVariableAssignment, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val name = NameIdentifierSerializer.serialize(node.name)
    val value = AstToSerializableMapper.serialize(node.value)
    val children: Seq[SerializableAstNode] = Seq(_annotations, name, value)
    NodeSerializableAstNode(SerializableAstNodeKind.USING_VARIABLE_ASSIGNMENT_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): UsingVariableAssignment = {
    val name = NameIdentifierSerializer.deserialize(children.head, context)
    val value = AstToSerializableMapper.deserialize(children(1), context)
    UsingVariableAssignment(name, value)
  }
}
