package org.mule.weave.v2.interpreted.marker

import org.mule.weave.v2.interpreted.InterpreterPreCompilerMarker
import org.mule.weave.v2.parser.annotation.AstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.scope.ScopesNavigator

class LazyVarDirectiveMarker extends InterpreterPreCompilerMarker {

  override def mark(node: AstNode, scope: ScopesNavigator, context: ParsingContext): Unit = {
    node match {
      case vd: VarDirective =>
        if (!vd.variable.isAnnotatedWith(classOf[LazyVarDirectiveAnnotation])) {
          // We detected that the annotation is a Lazy annotation
          val maybeLazyAnnotation = vd.codeAnnotations.find(ann => {
            val resolvedAnnotationRef = scope.resolveVariable(ann.name)
            resolvedAnnotationRef.exists(ref => ref.fqnReferenceName == NameIdentifier.LAZY)
          })

          if (maybeLazyAnnotation.isDefined) {
            vd.variable.annotate(LazyVarDirectiveAnnotation())
          }
        }
      case _ =>
      // Nothing to do
    }
  }
}

case class LazyVarDirectiveAnnotation() extends AstNodeAnnotation {

  override def name(): String = {
    "LazyVarDirective"
  }
}