package org.mule.weave.v2.runtime.core.functions.numberops

import org.mule.weave.v2.core.functions.BinaryFunctionValue
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.types.NumberType
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.NumberValue
import org.mule.weave.v2.model.values.StringValue
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.math.Number

object NumberToRadixFunction extends BinaryFunctionValue {
  override val L = NumberType
  override val R = NumberType
  override protected def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val number = leftValue.evaluate
    val radix = rightValue.evaluate
    if (number.isWhole || ctx.serviceManager.settingsService.execution().strictToBigInt)
      StringValue(number.toBigInt.toString(radix.toInt))
    else
      StringValue(number.floor.toBigInt.toString(radix.toInt))
  }
}

object StringWithRadixToNumber extends BinaryFunctionValue {
  override val L = StringType
  override val R = NumberType

  override protected def doExecute(leftValue: L.V, rightValue: R.V)(implicit ctx: EvaluationContext): Value[_] = {
    val strNumber = leftValue.evaluate.toString
    val radix = rightValue.evaluate
    NumberValue(Number(BigInt(strNumber, radix.toInt)))
  }
}

object NumberConversionFunctions {

}
