package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.SerializerContext
import org.mule.weave.v2.parser.ast.types.NativeTypeNode

object NativeTypeNodeSerializer extends AstNodeSerializer[NativeTypeNode] {

  override protected def doSerialize(node: NativeTypeNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val typeId = serializeString(node.typeId)
    val asSchema = SchemaNodeSerializer.serializeMaybe(node.asSchema)
    val children: Seq[SerializableAstNode] = Seq(_annotations, typeId, asSchema)
    NodeSerializableAstNode(SerializableAstNodeKind.NATIVE_TYPE_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): NativeTypeNode = {
    val typeId = deserializeString(children.head)
    val asSchema = SchemaNodeSerializer.deserializeMaybe(children(1), context)
    NativeTypeNode(typeId, asSchema)
  }
}
