package org.mule.weave.v2.runtime.core.functions

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.service.SecurityPrivilegeViolation
import org.mule.weave.v2.model.service.WeaveRuntimePrivilege
import org.mule.weave.v2.model.types.StringType
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.parser.location.LocationCapable

import java.nio.charset.Charset

/**
  * Parses the content of the first argument using the specified mimeType and the specified reader properties.
  * The content is an url. This parameter is mandatory
  * The mimeType of the content is optional, by default it's application/dw
  * A map with the reader properties is optional.
  */
object ReadUrlFunctionValue extends ReadFunctionValue {

  val requiredPrivilege: WeaveRuntimePrivilege = WeaveRuntimePrivilege.RESOURCE

  override def doExecute(firstValue: First.V, secondValue: Second.V, thirdValue: Third.V)(implicit ctx: EvaluationContext): Value[_] = {
    if (!ctx.serviceManager.securityManager.supports(requiredPrivilege, Array.empty)) {
      throw new SecurityPrivilegeViolation(requiredPrivilege, location())
    }
    super.doExecute(firstValue, secondValue, thirdValue)
  }

  override protected def createSourceProvider(st: StringType#T, locatable: LocationCapable, charset: Charset)(implicit ctx: EvaluationContext): SourceProvider = {
    ctx.serviceManager.resourceResolver.resolveResource(st.toString, locatable, charset)
  }
}
