package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.patterns.EmptyArrayPatternNode

object EmptyArrayPatternNodeSerializer extends AstNodeSerializer[EmptyArrayPatternNode] {

  override protected def doSerialize(node: EmptyArrayPatternNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val onMatch = AstToSerializableMapper.serialize(node.onMatch)
    val children: Seq[SerializableAstNode] = Seq(_annotations, onMatch)
    NodeSerializableAstNode(SerializableAstNodeKind.EMPTY_ARRAY_PATTERN_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): EmptyArrayPatternNode = {
    val onMatch = AstToSerializableMapper.deserialize(children.head, context)
    EmptyArrayPatternNode(onMatch)
  }
}
