package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.selectors.ExistsSelectorNode

object ExistsSelectorNodeSerializer extends AstNodeSerializer[ExistsSelectorNode] {

  override protected def doSerialize(node: ExistsSelectorNode, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val selectable = AstToSerializableMapper.serialize(node.selectable)
    val children: Seq[SerializableAstNode] = Seq(_annotations, selectable)
    NodeSerializableAstNode(SerializableAstNodeKind.EXISTS_SELECTOR_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): ExistsSelectorNode = {
    val selectable = AstToSerializableMapper.deserialize(children.head, context)
    ExistsSelectorNode(selectable)
  }
}
