package org.mule.weave.v2.compilation.mapper.ast

import org.mule.weave.v2.compilation._
import org.mule.weave.v2.compilation.mapper.{ AstToSerializableMapper, SerializerContext }
import org.mule.weave.v2.parser.ast.functions.FunctionParameter
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

object FunctionParameterSerializer extends AstNodeSerializer[FunctionParameter] {

  override protected def doSerialize(node: FunctionParameter, location: SerializableAstNodeLocation, _annotations: ArraySerializableAstNode): SerializableAstNode = {
    val variable = NameIdentifierSerializer.serialize(node.variable)
    val defaultValue = AstToSerializableMapper.serializeMaybe(node.defaultValue)
    val wtype = AstToSerializableMapper.serializeMaybe(node.wtype)
    val annotations = AnnotationNodeSerializer.serializeSeq(node.codeAnnotations)
    val children: Seq[SerializableAstNode] = Seq(_annotations, variable, defaultValue, wtype, annotations)
    NodeSerializableAstNode(SerializableAstNodeKind.FUNCTION_PARAMETER_NODE, location, children)
  }

  override protected def doDeserialize(children: Seq[SerializableAstNode], context: SerializerContext): FunctionParameter = {
    val variable = NameIdentifierSerializer.deserialize(children.head, context)
    val defaultValue = AstToSerializableMapper.deserializeMaybe(children(1), context)
    val wtype = AstToSerializableMapper.deserializeMaybe(children(2), context).asInstanceOf[Option[WeaveTypeNode]]
    val annotations = AnnotationNodeSerializer.deserializeSeq(children(3), context)
    FunctionParameter(variable, defaultValue, wtype, annotations)
  }
}
